#include <iostream>
#include <cstring>
using namespace std;

const int MAX_N = 500005;

struct CvOr {
    int susedni[MAX_N];
    bool imaPlatformu;
};

void bfs(CvOr graf[], int snage[], int promene[], int n) {
    int minSkokovi[MAX_N];
    bool poseceni[MAX_N];

    memset(minSkokovi, -1, sizeof(minSkokovi));
    memset(poseceni, false, sizeof(poseceni));

    int red[MAX_N];
    int pocetak = 0, kraj = -1;

    minSkokovi[0] = 0;
    poseceni[0] = true;
    red[++kraj] = 0;

    while (pocetak <= kraj) {
        int trenutni = red[pocetak++];

        int snaga = snage[trenutni];
        int promena = promene[trenutni];

        if (promena != 0) {
            graf[trenutni].imaPlatformu = !graf[trenutni].imaPlatformu;
            if (graf[trenutni].imaPlatformu) {
                for (int i = 0; i < MAX_N; ++i) {
                    int sused = graf[trenutni].susedni[i];
                    if (sused != -1 && !graf[sused].imaPlatformu) {
                        minSkokovi[sused] = minSkokovi[trenutni] + 1;
                        red[++kraj] = sused;
                        poseceni[sused] = true;
                    }
                }
            }
        }

        if (snaga >= trenutni + 1 && !poseceni[snaga - trenutni - 1] && !graf[snaga - trenutni - 1].imaPlatformu) {
            minSkokovi[snaga - trenutni - 1] = minSkokovi[trenutni] + 1;
            red[++kraj] = snaga - trenutni - 1;
            poseceni[snaga - trenutni - 1] = true;
        }
    }

    for (int i = 0; i < n; ++i) {
        cout << minSkokovi[i] << " ";
    }
    cout << endl;
}

int main() {
    int n;
    cin >> n;

    CvOr graf[n];
    int snage[n - 1];
    int promene[n];

    for (int i = 0; i < n; ++i) {
        memset(graf[i].susedni, -1, sizeof(graf[i].susedni));
    }

    for (int i = 0; i < n - 1; ++i) {
        int u, v;
        cin >> u >> v;
        graf[u - 1].susedni[i] = v - 1;
        graf[v - 1].susedni[i] = u - 1;
    }

    for (int i = 0; i < n; ++i) {
        cin >> promene[i];
    }

    for (int i = 0; i < n; ++i) {
        cin >> snage[i];
    }

    bfs(graf, snage, promene, n);

    return 0;
}